Ext.data.JsonP.sol_common_ix_services_GenerateSetInstructions({"tagname":"class","name":"sol.common.ix.services.GenerateSetInstructions","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.services.GenerateSetInstructions.js","href":"sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions"}],"author":[{"tagname":"author","name":"ESt, ELO Digital Office GmbH","email":null}],"eloix":true,"requires":["sol.common.JsonUtils","sol.common.ObjectFormatter","sol.common.RepoUtils","sol.common.SordUtils","sol.common.Template","sol.common.WfUtils","sol.common.ix.RfUtils","sol.common.ix.ServiceBase"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.ServiceBase","mixins":[],"uses":[],"members":[{"name":"dataSource","tagname":"cfg","owner":"sol.common.ix.services.GenerateSetInstructions","id":"cfg-dataSource","meta":{}},{"name":"dataSourceFlowId","tagname":"cfg","owner":"sol.common.ix.services.GenerateSetInstructions","id":"cfg-dataSourceFlowId","meta":{}},{"name":"escapeHTML","tagname":"cfg","owner":"sol.common.ix.services.GenerateSetInstructions","id":"cfg-escapeHTML","meta":{}},{"name":"mandatoryFields","tagname":"cfg","owner":"sol.common.ix.services.GenerateSetInstructions","id":"cfg-mandatoryFields","meta":{}},{"name":"mapping","tagname":"cfg","owner":"sol.common.ix.services.GenerateSetInstructions","id":"cfg-mapping","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.ServiceBase","id":"cfg-objId","meta":{}},{"name":"protectedFields","tagname":"cfg","owner":"sol.common.ix.services.GenerateSetInstructions","id":"cfg-protectedFields","meta":{}},{"name":"renderOptions","tagname":"cfg","owner":"sol.common.ix.services.GenerateSetInstructions","id":"cfg-renderOptions","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"returnMappingsOnly","tagname":"cfg","owner":"sol.common.ix.services.GenerateSetInstructions","id":"cfg-returnMappingsOnly","meta":{}},{"name":"returnRendered","tagname":"cfg","owner":"sol.common.ix.services.GenerateSetInstructions","id":"cfg-returnRendered","meta":{}},{"name":"reverseMapping","tagname":"cfg","owner":"sol.common.ix.services.GenerateSetInstructions","id":"cfg-reverseMapping","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"data","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-data","meta":{}},{"name":"logger","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"buildInstructionsFromTemplateSord","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-buildInstructionsFromTemplateSord","meta":{"private":true}},{"name":"checkMandatoryProperties","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-checkMandatoryProperties","meta":{"protected":true}},{"name":"containsClassName","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-containsClassName","meta":{}},{"name":"executeMapping","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-executeMapping","meta":{"private":true}},{"name":"filterInstructions","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-filterInstructions","meta":{"private":true}},{"name":"filterProtectedFields","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-filterProtectedFields","meta":{"private":true}},{"name":"findMissingMandatories","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-findMissingMandatories","meta":{"private":true}},{"name":"getConvertedData","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-getConvertedData","meta":{"private":true}},{"name":"getSordData","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-getSordData","meta":{"private":true}},{"name":"getTemplate","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-getTemplate","meta":{"private":true}},{"name":"getType","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-getType","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-initialize","meta":{"private":true}},{"name":"mappingContainsFormBlobs","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-mappingContainsFormBlobs","meta":{"private":true}},{"name":"prefillMetadata","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-prefillMetadata","meta":{"protected":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-process","meta":{}},{"name":"reverseMappings","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"method-reverseMappings","meta":{"private":true}},{"name":"RF_sol_common_service_GenerateSetInstructions","tagname":"method","owner":"sol.common.ix.services.GenerateSetInstructions","id":"static-method-RF_sol_common_service_GenerateSetInstructions","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.services.GenerateSetInstructions","short_doc":"Converts a TemplateSord to SET-compatible\ninstructions/entries optionally using a mapping and returns them. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.ServiceBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a><div class='subclass '><strong>sol.common.ix.services.GenerateSetInstructions</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter' rel='sol.common.ObjectFormatter' class='docClass'>sol.common.ObjectFormatter</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions' target='_blank'>sol.common.ix.services.GenerateSetInstructions.js</a></div></pre><div class='doc-contents'><p>Converts a <a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">TemplateSord</a> to <a href=\"#!/api/sol.common.ix.functions.Set\" rel=\"sol.common.ix.functions.Set\" class=\"docClass\">SET</a>-compatible\n<a href=\"#!/api/sol.common.ix.functions.Set-cfg-entries\" rel=\"sol.common.ix.functions.Set-cfg-entries\" class=\"docClass\">instructions/entries</a> optionally using a <a href=\"#!/api/sol.common.ix.services.GenerateSetInstructions-cfg-mapping\" rel=\"sol.common.ix.services.GenerateSetInstructions-cfg-mapping\" class=\"docClass\">mapping</a> and returns them.</p>\n\n<h3>Mapping definitions</h3>\n\n<p>A mapping definition consists of source-fields and their respective target-fields.</p>\n\n<pre><code>{ source: { id: \"MY_FIELD\", type: \"GRP\" }, target: { id: \"YOUR_FIELD\", type: \"GRP\" } }\n</code></pre>\n\n<p>Resulting instruction:</p>\n\n<pre><code>{ id: \"YOUR_FIELD\", type: \"GRP\", value: \"{{sord.objKeys.MY_FIELD}}\" }\n</code></pre>\n\n<p>You must pass true as the <code>returnRendered</code> parameter and a valid objId (String) or templateSord (Object) as the <code>dataSource</code> parameter, if you want the value to be rendered in the result.</p>\n\n<p>It is also possible to define custom values which do not occur in the <code>dataSource</code> by including them in the mapping definition's target property:</p>\n\n<pre><code>{ target: { id: \"Y_FIELD\", type: \"MAP\", value: \"{{sord.mapKeys.MY_CUSTOM_FIELD}} fixed text\" } }\n</code></pre>\n\n<p>If some values which are available in the dataSource should not be added to the generated instructions, the values can be defined as a <code>source</code> without a <code>target</code></p>\n\n<pre><code>{ source: { id: NO_FIELD, type: \"MAP\" } }\n</code></pre>\n\n<p>If you pass a templateSord as <code>dataSource</code>, the templateSord will be used as <code>sord</code> in any templating.</p>\n\n<p>If you pass an objid as <code>dataSource</code> and a flowId as <code>dataSourceFlowId</code>, the sord will be checked out and used in templating.</p>\n\n<h3>Empty non rendered values</h3>\n\n<p>As a default, if returnRendered is true and a value could not be rendered, the original template-String will be used as the <code>value</code> in the generated instruction.\nIf you define <code>renderOptions: { emptyNonRendered: true }</code>, templates which were not rendered, will be written to the instruction as an empty String.\nNonRendered means, the templating result is an empty string.</p>\n\n<h3>Only generate instructions for mapped values</h3>\n\n<p>If only some values of the dataSource should be used for generating instructions, defining <code>returnMappingsOnly: true</code> will only add those values defined in the mapping\nto the resulting instructions.</p>\n\n<h3>Reverse Mappings</h3>\n\n<p>Option <code>reverseMapping: true</code> can be used, to switch source and target mapping options. (this is e.g. useful for HR-requests.)</p>\n\n<h3>Examples</h3>\n\n<h3>Using a TemplateSord and a mapping</h3>\n\n<h4>Arguments</h4>\n\n<pre><code>{\n  dataSource: {\n    objKeys: {\n      MY_FIELD: \"myvalue\"\n    },\n    mapKeys: {\n      NO_FIELD: \"xyz\",\n      MY_CUSTOM_FIELD: \"this is\"\n    }\n  },\n  mapping: [\n    { source: { id: \"MY_FIELD\", type: \"GRP\" }, target: { id: \"YOUR_FIELD\", type: \"GRP\" } },\n    { target: { id: \"Y_FIELD\", type: \"MAP\", value: \"{{sord.mapKeys.MY_CUSTOM_FIELD}} fixed text\" } },\n    { source: { id: \"NO_FIELD\", type: \"MAP\" } },\n    { target: { id: \"OLD_DATAHISTORY\", type: \"FORMBLOB\", value: \"{{sord.formBlobs.DATAHISTORY}}\" } }\n  ],\n  returnRendered: true,\n  renderOptions: {\n    emptyNonRendered: true\n  }\n}\n</code></pre>\n\n<h4>Return value</h4>\n\n<pre><code>{\n  id: \"SetInstructions\",\n  dataSource: {\n    objKeys: {\n      MY_FIELD: \"myvalue\"\n    },\n    mapKeys: {\n      NO_FIELD: \"xyz\",\n      MY_CUSTOM_FIELD: \"this is\"\n    }\n  },\n  instructions: [\n    { key: \"YOUR_FIELD\", type: \"GRP\", value: \"myvalue\" },\n    { key: \"Y_FIELD\", type: \"MAP\", value: \"this is fixed text\" },\n    { key: \"OLD_DATAHISTORY\", type: \"FORMBLOB\", value: \"\" }\n  ],\n  rendered: true\n}\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-dataSource' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-cfg-dataSource' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-cfg-dataSource' class='name expandable'>dataSource</a> : String|Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>objId or templateSord</p>\n</div><div class='long'><p>objId or templateSord</p>\n</div></div></div><div id='cfg-dataSourceFlowId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-cfg-dataSourceFlowId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-cfg-dataSourceFlowId' class='name expandable'>dataSourceFlowId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nflowId. ...</div><div class='long'><p>(optional)\nflowId. This will only be used, if <code>dataSource</code> is an objectId</p>\n</div></div></div><div id='cfg-escapeHTML' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-cfg-escapeHTML' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-cfg-escapeHTML' class='name expandable'>escapeHTML</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nif set to false, template strings will be generated so html won't be escaped ...</div><div class='long'><p>(optional)\nif set to false, template strings will be generated so html won't be escaped</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-mandatoryFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-cfg-mandatoryFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-cfg-mandatoryFields' class='name expandable'>mandatoryFields</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) (throws exception if a field is missing) ...</div><div class='long'><p>(optional) (throws exception if a field is missing)</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>type</span> : String|\"GRP\"|\"MAP\"|\"WFMAP\"|\"FORMBLOB\"<div class='sub-desc'>\n</div></li><li><span class='pre'>id</span> : String<div class='sub-desc'><p>name of mandatory field</p>\n</div></li></ul></div></li></ul></div></div></div><div id='cfg-mapping' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-cfg-mapping' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-cfg-mapping' class='name expandable'>mapping</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>source</span> : Object<div class='sub-desc'><p>(optional)</p>\n<ul><li><span class='pre'>id</span> : String<div class='sub-desc'><p>name of source field</p>\n</div></li><li><span class='pre'>type</span> : String|\"GRP\"|\"MAP\"|\"WFMAP\"|\"FORMBLOB\"<div class='sub-desc'><p>type of field</p>\n</div></li></ul></div></li><li><span class='pre'>target</span> : Object<div class='sub-desc'><p>(optional)</p>\n<ul><li><span class='pre'>id</span> : String<div class='sub-desc'><p>name of target field</p>\n</div></li><li><span class='pre'>type</span> : String|\"GRP\"|\"MAP\"|\"WFMAP\"|\"FORMBLOB\"<div class='sub-desc'><p>type of field</p>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'><p>(optional) fixed or template String. This is completely optional!</p>\n</div></li></ul></div></li></ul></div></li></ul></div></div></div><div id='cfg-objId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-protectedFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-cfg-protectedFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-cfg-protectedFields' class='name expandable'>protectedFields</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>type</span> : String|\"GRP\"|\"MAP\"|\"WFMAP\"|\"FORMBLOB\"<div class='sub-desc'>\n</div></li><li><span class='pre'>id</span> : String<div class='sub-desc'><p>name of protected field</p>\n</div></li></ul></div></li></ul></div></div></div><div id='cfg-renderOptions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-cfg-renderOptions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-cfg-renderOptions' class='name expandable'>renderOptions</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nadditional options for rendering ...</div><div class='long'><p>(optional)\nadditional options for rendering</p>\n<ul><li><span class='pre'>emptyNonRendered</span> : Boolean (optional)<div class='sub-desc'><p>(optional)\nempty value if handlebars could not render template</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-returnMappingsOnly' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-cfg-returnMappingsOnly' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-cfg-returnMappingsOnly' class='name expandable'>returnMappingsOnly</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\ninstructionset will only contain instructions resulting from a mapping ...</div><div class='long'><p>(optional)\ninstructionset will only contain instructions resulting from a mapping</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-returnRendered' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-cfg-returnRendered' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-cfg-returnRendered' class='name expandable'>returnRendered</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\ndecides if resulting instructions will go through handlebars ...</div><div class='long'><p>(optional)\ndecides if resulting instructions will go through handlebars</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-reverseMapping' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-cfg-reverseMapping' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-cfg-reverseMapping' class='name expandable'>reverseMapping</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nswitches target and source in every mapping ...</div><div class='long'><p>(optional)\nswitches <code>target</code> and <code>source</code> in every mapping</p>\n<p>Defaults to: <code>false</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-data' class='name expandable'>data</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div><div class='long'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the service</p>\n</div><div class='long'><p>The logger for the service</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-buildInstructionsFromTemplateSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-buildInstructionsFromTemplateSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-buildInstructionsFromTemplateSord' class='name expandable'>buildInstructionsFromTemplateSord</a>( <span class='pre'>tSord</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tSord</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-checkMandatoryProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-checkMandatoryProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-checkMandatoryProperties' class='name expandable'>checkMandatoryProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Checks if all mandatory properties have been set. ...</div><div class='long'><p>Checks if all mandatory properties have been set.</p>\n</div></div></div><div id='method-containsClassName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-containsClassName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-containsClassName' class='name expandable'>containsClassName</a>( <span class='pre'>classNames</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether an array contains the class name ...</div><div class='long'><p>Checks wether an array contains the class name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classNames</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-executeMapping' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-executeMapping' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-executeMapping' class='name expandable'>executeMapping</a>( <span class='pre'>mappings</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mappings</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-filterInstructions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-filterInstructions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-filterInstructions' class='name expandable'>filterInstructions</a>( <span class='pre'>instructions, mappings</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>returns templateSord-instructions which were not mapped ...</div><div class='long'><p>returns templateSord-instructions which were not mapped</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>mappings</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-filterProtectedFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-filterProtectedFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-filterProtectedFields' class='name expandable'>filterProtectedFields</a>( <span class='pre'>instructions, protected</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>protected</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-findMissingMandatories' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-findMissingMandatories' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-findMissingMandatories' class='name expandable'>findMissingMandatories</a>( <span class='pre'>instructions, mandatories</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instructions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>mandatories</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getConvertedData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-getConvertedData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-getConvertedData' class='name expandable'>getConvertedData</a>( <span class='pre'>mapping, tplObj, flowId, render, renderOptions, asAdmin, formBlobs</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mapping</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>tplObj</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>flowId</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>render</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>renderOptions</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>asAdmin</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>formBlobs</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getSordData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-getSordData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-getSordData' class='name expandable'>getSordData</a>( <span class='pre'>objId, flowId, asAdmin, formBlobs</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>flowId</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>asAdmin</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>formBlobs</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-getTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-getTemplate' class='name expandable'>getTemplate</a>( <span class='pre'>name, type</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>type</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-getType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-getType' class='name expandable'>getType</a>( <span class='pre'>objName</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objName</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-mappingContainsFormBlobs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-mappingContainsFormBlobs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-mappingContainsFormBlobs' class='name expandable'>mappingContainsFormBlobs</a>( <span class='pre'>mapping</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mapping</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-prefillMetadata' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-prefillMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-prefillMetadata' class='name expandable'>prefillMetadata</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Initializes the metadata of an element (defined by objId) from the internal data object. ...</div><div class='long'><p>Initializes the metadata of an element (defined by <code>objId</code>) from the internal <code>data</code> object.</p>\n\n<p>The <code>data</code> property has to be in a specific <a href=\"#!/api/sol.common.ix.ServiceBase-property-data\" rel=\"sol.common.ix.ServiceBase-property-data\" class=\"docClass\">form</a>.\nIf there is no data object no prefilling will be performed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-process' class='name expandable'>process</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n<ul><li><span class='pre'>instructions</span> : Object[]<div class='sub-desc'><p>instructions usable as SET-entries</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>target field name</p>\n</div></li><li><span class='pre'>type</span> : String|\"GRP\"|\"MAP\"|\"WFMAP\"|\"FORMBLOB\"<div class='sub-desc'><p>target field type</p>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'><p>target field value</p>\n</div></li></ul></div></li></ul></div></li><li><span class='pre'>rendered</span> : Boolean<div class='sub-desc'><p>if the <code>value</code>s in <code>instructions</code> are rendered</p>\n</div></li></ul></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-method-process\" rel=\"sol.common.ix.ServiceBase-method-process\" class=\"docClass\">sol.common.ix.ServiceBase.process</a></p></div></div></div><div id='method-reverseMappings' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-method-reverseMappings' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-method-reverseMappings' class='name expandable'>reverseMappings</a>( <span class='pre'>mappings</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mappings</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_common_service_GenerateSetInstructions' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GenerateSetInstructions'>sol.common.ix.services.GenerateSetInstructions</span><br/><a href='source/sol.common.ix.services.GenerateSetInstructions.html#sol-common-ix-services-GenerateSetInstructions-static-method-RF_sol_common_service_GenerateSetInstructions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GenerateSetInstructions-static-method-RF_sol_common_service_GenerateSetInstructions' class='name expandable'>RF_sol_common_service_GenerateSetInstructions</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});